# kenbaikiについて

## ファイル一覧
kenbaiki.v : *券売機のRTLファイル*

kenbaiki_TB.v : *kenbaiki.vのテストベンチ*

## 設計について
50円券と100円券を売り出す券売機を考える．
お金は50円玉と100円玉だけを受け付け，投入された金額に応じた券を出す（100円分入ってたら50円券は買えず，必ず100円券が出てくる）．
券売機は箱に，お金の投入口，発券ボタン1つ，発券口，余剰なお金の払い戻し口がついている構成．以下，入出力の詳細．

    input [1:0] in;  //お金の入力（2ビット），上位ビットがお金投入の有無，下位ビットがお金の種類
    input ticket;  //発券ボタンの入力，投入されている金額に応じた券を発券
    output [1:0] payback;  //余剰な投入金額の払い戻し出力，上位ビットが払い戻しの有無，下位ビットががお金の種類
    output [1:0] out;  //発券の出力，上位ビットが発券の有無，下位ビットが券の種類

    input clk, reset_N;  //クロック信号とリセット信号の入力

このように，何を入力で与え，それぞれのビット幅がいくつになるのか，それぞれのビットは何を表すのかをきちんと決めることが設計で重要になってくる．

## ブロッキング代入とノンブロッキング代入について
verilogだと，代入文が "=" と "<=" の二種類ある．

"="がブロッキング代入で，ファイルの上から順番に代入をしていく逐次処理の構文，"<="がノンブロッキング代入で，代入したい値が変化したら即座に代入される．

assignでは "=" を，always文中では "<=" を使った方がいいのだが，この券売機の例では全部 "=" になっているので注意．