// kenbaiki_TB.v
`timescale 1ns/1fs

module kenbaiki_TB;
  reg  ticket, clk, reset_N; // input
  reg  [1:0] in;             // input
  wire [1:0] payback, out;   // output

  parameter CLOCK = 2.0;  // クロック周期(ns)

  kenbaiki kenbaiki(in, ticket, clk, reset_N, payback, out); // テストにかける回路の準備

  initial clk = 1;   // クロックの準備
  always #(CLOCK/2)  // クロックを作っている
    clk <= ~clk;

   initial   // おまじない
   begin
     $dumpfile("rtl.dump");     // 出力されるダンプファイル(これを元に波形が見れます)
     $dumpvars(0,kenbaiki_TB);
   end

  initial  // おまじないらしいよ
  begin
      in <= 2'b00;
      ticket <= 1'b0; //初期化
      reset_N <= 1'b0; //resetは0入力でかかる
    repeat(2) @(negedge clk); // 信号の変化はクロック立ち上がりでやってはよくない
                              // そのため2つクロックが立ち下がるまで待つ
      reset_N <= 1'b1; //リセットを解除

    //50円->待機->50円->発券
    #(CLOCK) // 1クロック待機
      in <= 2'b10;
    #(CLOCK) // 1クロック待機
      in <= 2'b00;
    #(CLOCK) // 1クロック待機
      in <= 2'b10;
    #(CLOCK)
      in <= 2'b00;
      ticket <= 1'b1;

    //50円->発券
    #(CLOCK) // 1クロック待機
      in <= 2'b10;
      ticket <= 1'b0;
    #(CLOCK)
      in <= 2'b00;
      ticket <= 1'b1;

    //100円->50円->発券
    #(CLOCK) // 1クロック待機
      in <= 2'b11;
      ticket <= 1'b0;
    #(CLOCK) // 1クロック待機
      in <= 2'b10;
    #(CLOCK)
      in <= 2'b00;
      ticket <= 1'b1;

    //50円->100円->発券
    #(CLOCK) // 1クロック待機
      in <= 2'b10;
      ticket <= 1'b0;
    #(CLOCK) // 1クロック待機
      in <= 2'b11;
    #(CLOCK)
      in <= 2'b00;
      ticket <= 1'b1;

    #(CLOCK*6) //6クロック待機

    $finish; //シミュレーション終了
  end
endmodule
