# Drone Programming
Use "Parrot AR.Drone 2.0 Power Edition"

## Setup

### Ubuntu 12.04

http://ftp.jaist.ac.jp/pub/Linux/ubuntu-releases/12.04/

### Processing 3.3.6

Install

```
sudo apt-get install openjdk-7-jdk
wget http://download.processing.org/processing-3.3.6-linux64.tgz
tar -xzvf processing-3.3.6-linux64.tgz
```

Start

```
cd processing-3.3.6
./processing [inputfile(.pde)]
```

### ARDroneForP5

Engineering Navi: http://kougaku-navi.net/ARDroneForP5/

GitHub: https://github.com/shigeodayo/ARDroneForP5

Install

```
git clone https://github.com/shigeodayo/ARDroneForP5.git
mkdir tmp
cd tmp
wget http://ftp.jaist.ac.jp/pub/apache/commons/net/binaries/commons-net-3.6-bin.tar.gz
tar -xzvf commons-net-3.6-bin.tar.gz
cp ./commons-net-3.6/commons-net-3.6.jar ../ARDroneForP5/lib/
wget http://www.dcm4che.org/maven2/xuggle/xuggle-xuggler/5.4/xuggle-xuggler-5.4.jar --no-check-certificate
cp ./xuggle-xuggler-5.4.jar ../ARDroneForP5/lib/
wget https://www.slf4j.org/dist/slf4j-1.7.25.tar.gz --no-check-certificate
tar -xzvf slf4j-1.7.25.tar.gz
cp ./slf4j-1.7.25/slf4j-api-1.7.25.jar ../ARDroneForP5/lib/
cp ./slf4j-1.7.25/slf4j-jdk14-1.7.25.jar ../ARDroneForP5/lib/
```

Build ... Generate "ARDroneForP5.jar"

```
cd ../ARDroneForP5
cd library
mv ARDroneForP5.jar ARDroneForP5_old.jar
cd ..
```

* Need to replace "build.xml".
* Need to fix 8 java files due to encoding bugs.

```
ant
```

* "ARDroneForP5.jar" is generated in the directory "library".
* 2 warings are displayed. (Unverified)

Have to add the following libraries before running an example sketch. (In menu bar, Sketch -> Add File...)
* library/ARDroneForP5.jar
* lib/commons-net-3.6.jar
* lib/xuggle-xuggler-5.4.jar
* lib/slf4j-api-1.7.25.jar
* lib/slf4j-jdk14-1.7.25.jar

Reconstructed "ARDroneForP5.jar" is not the same as the original.

**TODO**: Operation verification

### Reference

Related to Ant, javac, ...

* http://www.techscore.com/tech/Java/ApacheJakarta/Ant/1/#ant1-2
* https://teratail.com/questions/100538
* https://detail.chiebukuro.yahoo.co.jp/qa/question_detail/q14121012059
* https://docs.oracle.com/javase/jp/1.5.0/tooldocs/windows/classpath.html
* https://qiita.com/toshiro3/items/6aed479e3cca47352b18
* http://www.ne.jp/asahi/hishidama/home/tech/ant/tag/delete.html

Related to Drone, ...

* https://github.com/kotarot/Proken-Drone2017

