#ifndef __ROUTER_HPP__
#define __ROUTER_HPP__

#include <iostream>

#ifdef SOFTWARE
	#include "ap_int.h"
#else
	#include <ap_int.h>
#endif

using namespace std;

#define ROUND_END 32768 // Max=65534(=2^16-2)
#define PRINT_BOARD
//#define PRINT_SEARCH // for router debug

#define MAX_LINES 256
#define MAX_PATH 128
#define MAX_CELLS 16384 // 128x128

#define PQ_BIT     12
#define MAX_PQ   4096

#define PRIO_BIT   16
#define DATA_BIT   16
#define ELEM_BIT   32 // ELEM_BIT = PRIO_BIT + DATA_BIT

#define DATA_MASK  65535 // 0000 FFFF
#define DATA_MAX   65535 // FFFF
#define PRIO_MAX   65535 // FFFF

/** top function (User can set "seed" value manually when calling this function.) **/
int router(short int size_x, short int size_y, short int line_num, short int board_str[], ap_uint<32> seed = 12345);

static ap_uint<32> lfsr;
void lfsr_random_init(ap_uint<32> seed);
ap_uint<32> lfsr_random();
ap_uint<PRIO_BIT> new_weight(ap_uint<16> x);

void search(short int size_x, short int size_y, short int *path_size, ap_uint<DATA_BIT> path[MAX_PATH], ap_uint<DATA_BIT> start, ap_uint<DATA_BIT> goal, ap_uint<PRIO_BIT> w[MAX_CELLS]);
void enqueue(ap_uint<ELEM_BIT> pq_nodes[MAX_PQ], ap_uint<PRIO_BIT> priority, ap_uint<DATA_BIT> data, ap_uint<PQ_BIT> *pq_len, bool *is_empty);
void dequeue(ap_uint<ELEM_BIT> pq_nodes[MAX_PQ], ap_uint<PRIO_BIT> *ret_priority, ap_uint<DATA_BIT> *ret_data, ap_uint<PQ_BIT> *pq_len, bool *is_empty);

#endif /* __ROUTER_HPP__ */
