#include "router.hpp"

int main(int argc, char *argv[]){
	
	short int size_x = 10, size_y = 10;
	short int line_num = 6;
	
	short int board[10][10], board_str[100];
	
	int x, y;
	for(y = 0; y < size_y; y++) {
		for(x = 0; x < size_x; x ++) {
			board[y][x] = 0;
		}
	}
	
	// Terminal cells (value > 0)
	board[0][1] = 1;
	board[7][1] = 1;
	board[0][3] = 2;
	board[8][4] = 2;
	board[4][5] = 3;
	board[6][5] = 3;
	board[4][6] = 4;
	board[7][2] = 4;
	board[5][4] = 5;
	board[6][6] = 5;
	board[9][8] = 6;
	board[9][9] = 6;
	
	// Routing disenabled cells (value < 0)
	board[0][0] = -1;
	board[1][7] = -1;
	board[1][8] = -1;
	board[2][1] = -1;
	board[2][7] = -1;
	board[2][8] = -1;
	board[3][1] = -1;
	board[4][1] = -1;
	board[5][1] = -1;
	
	// Transform "board" to "board_str"
	for(y = 0; y < size_y; y++) {
		for(x = 0; x < size_x; x++) {
			int idx = y * size_x + x;
			board_str[idx] = board[y][x];
		}
	}
	
	/** top function of router **/
	// status = 1: OK
	// status = 0: NG
	int status = router(size_x, size_y, line_num, board_str);
	
	/** top function of router (User can set "seed" value manually when calling this function.) **/
	//int status = router(size_x, size_y, line_num, board_str, 1234567);
	
	cout << "Router status: " << status << endl;
	
	// Transform "board_str" to "board"
	for(y = 0; y < size_y; y++) {
		for(x = 0; x < size_x; x++) {
			int idx = y * size_x + x;
			board[y][x] = board_str[idx];
		}
	}
	
	return 0;
}
