# Basic router
* A*ベースの配線プログラム
* 入力
  * 盤面サイズ(size_x, size_y)
  * ライン数(line_num)
  * 盤面情報(size_x$`\times`$size_yの盤面に整数を割り当て，自然数: ライン端点，-1: 配線禁止領域, 0: 配線領域)
* 出力
  * status(自然数: 配線成功，0: 配線失敗)，配線成功時のstatusは総配線長を表す
  * 配線結果
* routerに渡す盤面情報，routerから返される配線結果は1次元配列(入力が2次元配列の場合，変換が必要)
* ハードウェア化に備えて余計な型やヘッダファイルを含むが，その辺はご了承願いたい...

### Change log
* 2019.07.16
  * 端点の隣接判定に関するバグを修正
  * 端点を結ぶパスが存在しないときにプログラムが停止するバグを修正
  * 配線成功時のstatusを総配線長に変更

### 関数呼び出し
* 関数routerの呼び出し方法は以下のサンプルコードの通り
* routerの第5引数はシード値で指定は任意(default=12345)

```
short int size_x = 10, size_y = 10;
short int line_num = 6;
short int board[10][10], board_str[100];

/* ここで盤面情報を設定 */

// Transform "board" to "board_str"
for(int y = 0; y < size_y; y++) {
	for(int x = 0; x < size_x; x++) {
		int idx = y * size_x + x;
		board_str[idx] = board[y][x];
	}
}

int status = router(size_x, size_y, line_num, board_str, 1234567);

// Transform "board_str" to "board"
for(int y = 0; y < size_y; y++) {
	for(int x = 0; x < size_x; x++) {
		int idx = y * size_x + x;
		board[y][x] = board_str[idx];
	}
}
```

### 必要ファイル
* router.cpp
* router.hpp
* ap_int.h
* etc/ap_fixed_sim.h
* etc/ap_int_sim.h
* etc/ap_private.h

### パラメタ
* router.hpp上部で以下を設定可能

|定数名|説明|
|:---|:---|
|ROUND_LIMIT|引きはがし再配線回数の上限(default: 32768, Max: 65534)，小さいほど諦めが早い|
|PRINT_BOARD|配線前と配線後の盤面を表示(コメントアウトで非表示)|
|PRINT_SEARCH|配線の途中経過をすべて表示(コメントアウトで非表示)|
