#include "tools.hpp"

void output_to_file(char *f_name, short int line_num, short int blocks, short int wi, short int hi, short int board[], short int block_place[][2]) {
	
	ofstream outputfile(f_name);
	
	outputfile << "SIZE " << wi << "X" << hi << endl;
	for(short int q = 0; q < hi; q++) {
		for(short int p = 0; p < wi; p++) {
			short int n = board[q*MAX_SIZE+p];
			if(n == 0) { outputfile << 0; }
			else if(n == -1) { outputfile << 0; }
			else{ outputfile << n; }
			if(p != wi-1) { outputfile << ", "; }
		}
		outputfile << endl;
	}
	outputfile << setfill(' ');
	outputfile << dec;
	for(int i = 1; i <= blocks; i++) {
		outputfile << "BLOCK#" << i << " @(" << block_place[i][0] << "," << block_place[i][1] << ")" << endl;
	}
	
	outputfile.close();
}

void show_result(short int line_num, short int blocks, short int wi, short int hi, short int board[]) {
	
	// This shows a number from 1 to 255
	for(short int q = 0; q < hi; q++) {
		for(short int p = 0; p < wi; p++) {
			short int n = board[q*MAX_SIZE+p];
			if(n == 0) { cout << "--"; }
			else if(n == -1) { cout << "XX"; }
			else{ cout << setfill('0') << setw(2) << hex << n; }
			if(p != wi-1) { cout << " "; }
		}
		cout << endl;
	}
	cout << setfill(' ');
	cout << dec;
}
