#ifndef __SOLVER_HPP__
#define __SOLVER_HPP__

#include <iostream>
#include <math.h>

#include "param.hpp"
#include "tools.hpp"

using namespace std;

int solver(uint32_t seed[3], short int W, short int H, short int blocks, short int line_num, short int block_info[][5][3], short int line_info[][2][5], short int *pwi, short int *phi, short int opt_result[]);

void lfsr_random_init(uint32_t seed, uint32_t seed_x, uint32_t seed_y);
uint32_t lfsr_random();
uint32_t lfsr_x_random();
uint32_t lfsr_y_random();

void global_placement(short int W, short int H, short int line_num, short int blocks, short int block_info[][5][3], short int line_info[][2][5], pair<short int,short int> block_place_global[]);
float calcPlaceCost(short int line_num, short int line_info[][2][5], pair<short int,short int> block_place_global[]);
bool local_placement_with_routing_1(short int line_num, short int blocks, short int *pwi, short int *phi, short int block_info[][5][3], pair<short int,short int> block_place_global[], short int opt_result[]);
bool local_placement_with_routing_2(short int line_num, short int blocks, short int *pwi, short int *phi, short int block_info[][5][3], short int opt_result[]);
pair<short int,short int> add_pair(pair<short int,short int> x, pair<short int,short int> y);
pair<short int,short int> sub_pair(pair<short int,short int> x, pair<short int,short int> y);

unsigned short int new_weight(unsigned short int x);

int router(short int size_x, short int size_y, short int line_num, short int board_str[MAX_CELLS]);

int search(short int size_x, short int size_y, short int *path_size, unsigned short int path[MAX_PATH], unsigned short int start, unsigned short int goal, unsigned short int w[MAX_CELLS]);
void enqueue(unsigned int pq_nodes[MAX_PQ], unsigned short int priority, unsigned short int data, unsigned short int *pq_len, bool *is_empty);
void dequeue(unsigned int pq_nodes[MAX_PQ], unsigned short int *ret_priority, unsigned short int *ret_data, unsigned short int *pq_len, bool *is_empty);

#endif /* __SOLVER_HPP__ */
