#ifndef __SOLVER_HPP__
#define __SOLVER_HPP__

//#define DEBUG_PRINT

#include <iostream>

#include "param.hpp"
#include <ap_int.h>
#include <hls_stream.h>
#ifdef DEBUG_PRINT
	#include "tools.hpp"
#endif

using namespace std;

bool solver(hls::stream<ap_uint<4> >& state, unsigned int seed[3], short int *pbnum, short int *plnum, short int block_info[MAX_BLOCKS+1][5][3], short int *pwi, short int *phi, short int block_place_global[MAX_BLOCKS+1][2], short int opt_result[MAX_CELLS]);

bool local_placement_1(short int line_num, short int blocks, short int *pwi, short int *phi, short int block_info[MAX_BLOCKS+1][5][3], short int block_place_global[MAX_BLOCKS+1][2], short int opt_result[MAX_CELLS]);
bool local_placement_2(short int line_num, short int blocks, short int *pwi, short int *phi, short int block_info[MAX_BLOCKS+1][5][3], short int opt_result[MAX_CELLS]);

int router(short int size_x, short int size_y, short int line_num, short int board_str[MAX_CELLS]);

int search(short int size_x, short int size_y, short int *path_size, unsigned short int path[MAX_PATH], unsigned short int start, unsigned short int goal, unsigned short int w[MAX_CELLS]);
void enqueue(unsigned int pq_nodes[MAX_PQ], unsigned short int queue_priority, unsigned short int queue_data, ap_uint<PQ_BIT> *pq_len, bool *is_empty);
void dequeue(unsigned int pq_nodes[MAX_PQ], unsigned short int *ret_priority, unsigned short int *ret_data, ap_uint<PQ_BIT> *pq_len, bool *is_empty);

#endif /* __SOLVER_HPP__ */
