#include <iostream>
#include <getopt.h>

#include "param.hpp"
#include "io.hpp"
#include "solver.hpp"
#include "tools.hpp"

using namespace std;

int main(int argc, char *argv[]) {
	
	char *out_filename = NULL;
	uint32_t seed_v = 214;
	
	// Get options
	struct option longopts[] = {
		{"output", required_argument, NULL, 'o'},
		{"seed", required_argument, NULL, 's'},
		{0, 0, 0, 0}
	};
	int opt, optidx;
	while((opt = getopt_long(argc, argv, "o:s:", longopts, &optidx)) != -1) {
		switch(opt) {
		case 'o':
			out_filename = optarg;
			break;
		case 's':
			sscanf(optarg, "%u", &seed_v);
			break;
		default:
			usage();
		}
	}
	
	// Init seed value
	uint32_t seed[3];
	srand(seed_v);
	seed[0] = rand();
	seed[1] = rand();
	seed[2] = rand();
	
	// W: Max width of a board (specified in a problem file)
	// H: Max height of a board (specified in a problem file)
	// blocks: # of blocks (specified in a problem file)
	short int W, H, blocks, line_num;
	// W_ext: Width of a current solution
	// H_ext: Height of a current solution
	short int W_ext, H_ext;
	
	// block data
	short int block_info[MAX_BLOCKS+1][5][3];
	
	// line data
	short int line_info[MAX_LINES+1][2][5];
	
	// An opt. result will be stored in the array
	short int opt_result[MAX_CELLS];
	
	// Check problem
	read_problem(&W, &H, &blocks, &line_num, block_info, line_info);
	extract_line_info(line_num, blocks, block_info, line_info);
	
	// Solver body
	int status = solver(seed, W, H, blocks, line_num, block_info, line_info, &W_ext, &H_ext, opt_result);
	
	// Check answer
	if(status == 0) {
		cout << "Fail re-routing" << endl;
	}
	else {
		cout << "== Answer ==" << endl;
		cout << "SIZE " << W_ext << "X" << H_ext << endl;
		pair<short int,short int> block_place_basis[MAX_BLOCKS+1];
		for(int i = 1; i <= blocks; i++) {
			block_place_basis[i] = make_pair(block_info[i][0][0], block_info[i][0][1]);
		}
		show_result(line_num, blocks, W_ext, H_ext, opt_result, block_place_basis);
	}
	if(W_ext > W || H_ext > H) {
		cout << "Fail satisfying constraint" << endl;
	}
	else {
		cout << "Satisfy constraint ^_^" << endl;
		if(out_filename == NULL) return 0;
		cout << "Output to " << out_filename << endl;
		pair<short int,short int> block_place_basis[MAX_BLOCKS+1];
		for(int i = 1; i <= blocks; i++) {
			block_place_basis[i] = make_pair(block_info[i][0][0], block_info[i][0][1]);
		}
		output_to_file(out_filename, line_num, blocks, W_ext, H_ext, opt_result, block_place_basis);
	}
	
	return 0;
}
