import os
import subprocess

proc = None
stop_flag = False

def stop():
    global proc
    global stop_flag

    stop_flag = True
    if not proc is None:
        proc.terminate()
        print('stopped')

def solve(params):
    global proc
    global stop_flag

    stop_flag = False

    # 必要な変数があるか確認
    assert('problem' in params)
    assert('timeout' in params)

    problem = params['problem']
    timeout = params['timeout']

    print(problem)
    
    # ソルバを実行するためのコマンドを指定
    command = f'sleep 100'
    cmds = command.split()

    if stop_flag:return {
        'status': 'stopped',
        'solution': '',
        }

    # ソルバを実行する準備
    proc = subprocess.Popen(
        cmds,
        stderr=subprocess.PIPE,
        stdout=subprocess.PIPE
    )

    print(' === start waiting === ')
    # ソルバを実行，タイムアウトしたらTimeoutExpiredになる
    try:
        outs, errs = proc.communicate(timeout=timeout)
        status = 'done'
    except subprocess.TimeoutExpired:
        proc.kill()
        outs, errs = proc.communicate()
        status = 'timeout'
    finally:
        returncode = proc.returncode
        outs = outs.decode()
        errs = errs.decode()
    
    # 解けたか解けなかったかによってstatusを適当なものに設定する
    # return
    if returncode == 0:
        if outs.startswith('SIZE'):
            status = 'done'
            solution = outs
        else:
            status = 'failed'
            solution = outs
    else:
        status = 'failed'
        solution = ''

    # 答えを返す
    return {
        'status': status,
        'solution': solution,
        # 'elapsed_time': 0.0 # 必要ならば足す，無ければシステム側で自動算出
        }

def main(params):
    solve(a)
