import os
import subprocess

PYTHON_BIN = "python3"
BASEDIR = os.path.abspath(os.path.dirname(__file__))
ADCCLI = f"{BASEDIR}/../adc2019/client/adccli"

def _exec_adccli(cmd):
    exec_cmd = f"{PYTHON_BIN} {ADCCLI} {cmd}".strip()
    print("ADCCLI: {}".format(exec_cmd))
    p = subprocess.run(exec_cmd, stdout=subprocess.PIPE, shell=True)
    res = p.stdout.decode().strip()
    print(res)
    return res

def login(url, username, password):
    cmd = f"--URL='{url}' --username='{username}' --password='{password}' login"
    return _exec_adccli(cmd)

def logout():
    cmd = "logout"
    return _exec_adccli(cmd)

def whoami():
    cmd = "whoami"
    return _exec_adccli(cmd)

def put_message(message):
    cmd = "put-user-alile '{}'"
    return _exec_adccli(cmd)

def post_user_q(qnum, filepath):
    cmd = "post-user-q {} {}".format(qnum, filepath)
    return _exec_adccli(cmd)

def get_q_all(outpath):
    cmd = "get-q"
    question_list = _exec_adccli(cmd).splitlines()

    print("--- ADCCLI questions ---")
    print(question_list)

    for l in question_list:
        if l.startswith("Q"):
            v = l.split()
            qnumber = int(v[0].replace("Q", ""))
            out_file_path = "{}/Q{:02d}.txt".format(outpath, qnumber)
            cmd = "--output {} get-q {}".format(out_file_path, qnumber)
            r = _exec_adccli(cmd)

    return question_list

def put_a(qnum, filepath):
    cmd = "put-a {} {}".format(qnum, filepath)
    return _exec_adccli(cmd)

def put_a_info(qnum, cpu, mem, misc):
    cmd = "put-a-info {} {} {} '{}'".format(qnum, cpu, mem, misc)
    return _exec_adccli(cmd)

