
// 詳細表示画面
class StatusView {

    constructor(selector) {
        this.container = $(selector);
        this.problem_key = null;
        this.request_refresh_timer = null;
        // this.solver_status_refresh_timer = null;

        this.event = Object();
    }

    // 問題詳細画面を表示
    show_problem(problem_key = null){
        var _this = this;
        if(problem_key != null){
            this.problem_key = problem_key;
        }

        $.ajax({
            type: 'GET',
            dataType: 'html',
            url: '/part/problem/' + _this.problem_key
        }).done((d) => {
            _this.container.empty();
            _this.container.html(d);

            clearInterval(_this.request_refresh_timer);

            _this.container.find('.start-button').click(()=>{
                _this.start_solver();
            });
            
            _this.container.find('.cancel-button').click(()=>{
                _this.cancel_problem();
            });
            
            _this.container.find('.save-button').click(()=>{
                _this.save_solution();
                _this.fire('refresh');
            });

            _this.container.find('.submit-button').click(()=>{
                _this.upload_solution();
            });

            _this.container.find('#chk-solver-all').prop('checked', false);
            
            _this.container.find('#chk-solver-all').on('change', (e) => {
                var _me = $(e.target);
                if(_me.prop('checked')){
                    _this.container.find('#solver-list-table-wrapper .chk-solver').each((i, el) => {
                        $(el).prop('checked', true);
                    });
                }else{
                    _this.container.find('#solver-list-table-wrapper .chk-solver').each((i, el) => {
                        $(el).prop('checked', false);
                    });
                }
            }).trigger('change');

            _this.request_refresh_timer = setInterval((function _t(){
                _this.update_status_view();
                return _t;
            }()), 1000);
        });
    }

    // 問題を解くのをスタート
    start_solver(){
        var _this = this;

        var solvers = new Array();

        _this.container.find('#solver-list-table-wrapper .chk-solver:checked').each((i, el) => {
            var _val = $(el).val();
            solvers.push(_val);
        });

        if(solvers.length == 0){
            alert("At least one solver must be selected.");
            return;
        }

        $.ajax({
            type: "POST",
            dataType: "json",
            url: "/api/problem/solve",
            data: JSON.stringify({
                "problem": _this.problem_key,
                "solvers": solvers
            }),
            contentType: 'application/json'
        }).done((d) => {
            console.log(d);
        });
    }
    
    cancel_problem(){
        var _this = this;

        var _button = _this.container.find('.cancel-button')
        _button.html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span><span class="sr-only">Loading...</span>');
        _button.prop('disabled', 'disabled');

        $.ajax({
            type: "POST",
            dataType: "json",
            url: "/api/cancel",
            data: JSON.stringify({
                "problem": _this.problem_key,
            }),
            contentType: 'application/json'
        }).done((d) => {
            _button.prop('disabled', false);
            _button.text('Cancel');
            console.log(d);
        });
    }
    
    // 強制停止
    stop_solver(){
        var _this = this;
        
        $.ajax({
            type: "GET",
            dataType: "json",
            url: "/api/stop",
        }).done((d) => {
            alert('Stopped');
        });
    }
    
    // 保存
    save_solution(){
        var _this = this;
        
        $.ajax({
            type: "POST",
            dataType: "json",
            url: "/api/problem/save",
            data: JSON.stringify({
                "problem": _this.problem_key
            }),
            contentType: 'application/json'
        }).done((d) => {
            _this.show_problem();
        });
    }
    
    // アップロード
    upload_solution(){
        var _this = this;
        
        $.ajax({
            type: "POST",
            dataType: "json",
            url: "/api/adccli/upload-solution",
            data: JSON.stringify({
                "problem": _this.problem_key
            }),
            contentType: 'application/json'
        }).done((d) => {
            alert(d['status']);
        });
    }

    update_status_view(){
        var _this = this;

        var solvers = new Array();

        _this.container.find('#solver-list-table-wrapper .chk-solver:checked').each((i, el) => {
            var _val = $(el).val();
            solvers.push(_val);
        });
        console.log(solvers);

        $.ajax({
            type: 'GET',
            dataType: 'html',
            url: '/part/problem_status/' + _this.problem_key
        }).done((d) => {

            _this.container.find('#problem-status-list-container').empty();
            _this.container.find('#problem-status-list-container').html(d);
            
            _this.container.find('.solution-detail-row.valid-solution td').click((e) => {
                var solution_id = $(e.target).parent("tr").data("solution-id");
                var problem_name = $(e.target).parent("tr").data("problem");
                var viewer_url = "/viewer#" + problem_name + "/" + solution_id;
                window.open(viewer_url, "_blank");
            });

            _this.fire('refresh');
        });
    }
    
    // システム詳細画面を表示
    show_system(){
        var _this = this;

        $.ajax({
            type: "GET",
            dataType: "html",
            url: "/part/system-summary"
        }).done((d) => {
            _this.container.empty();
            _this.container.html(d);

            clearInterval(_this.request_refresh_timer);

            var button_action_with_ajax = function($obj, url){
                $obj.prop("disabled", "disabled");
                $.ajax({
                    type: "GET",
                    url: url,
                    dataType: "json",
                }).done((data)=>{
                    $obj.prop("disabled", false);
                    alert(data['status']);
                });
            };
            
            var button_action_with_ajax_post = function($obj, url, param){
                $obj.prop("disabled", "disabled");
                $.ajax({
                    type: "POST",
                    url: url,
                    dataType: "json",
                    data: JSON.stringify(param),
                    contentType: 'application/json'
                }).done((data)=>{
                    $obj.prop("disabled", false);
                    alert(data['status']);
                });
            };
            
            $(".btn-worker-reset").click(function(){
                var param = {
                    "address": $(this).data('worker')
                };
                button_action_with_ajax_post($(this), "/api/worker/reset", param);
            });
            $(".btn-worker-stop").click(function(){
                var param = {
                    "address": $(this).data('worker')
                };
                button_action_with_ajax_post($(this), "/api/worker/stop", param);
            });

            $("#adccli-login-button").click(function(){
                button_action_with_ajax($(this), "/api/adccli/login");
            });
            $("#adccli-logout-button").click(function(){
                button_action_with_ajax($(this), "/api/adccli/logout");
            });
            $("#adccli-get-all-q").click(function(){
                button_action_with_ajax($(this), "/api/adccli/download-problem");
            });

            $.ajax({
                type: "GET",
                url: "/api/adccli/whoami",
                dataType: "json",
            }).done((data)=>{
                if(data['is_logged_in'])
                    $("#adccli-status").text("ログイン中");
                else
                    $("#adccli-status").text("ログアウト");
            });

        });
    }

    // イベントの追加
    on(key, func){
        if(!this.event.hasOwnProperty(key)){
            this.event[key] = Array();
        }
        this.event[key].push(func);
    }

    // イベントの発火
    fire(key){
        if(this.event.hasOwnProperty(key)){
            for(var i=0; i<this.event[key].length; i++){
                this.event[key][i]();
            }
        }
    }
}

// 問題一覧画面
class ProblemListView {

    constructor(selector) {
        this.container = $(selector);
    }

    refresh(){
        var _this = this;

        $.ajax({
            type: "GET",
            dataType: "html",
            url: "/part/problems"
        }).done((d) => {
            _this.container.empty();
            _this.container.html(d);

            var hash = location.hash.replace("#", "");
            if(hash != ""){
                _this.container.find(".problem-row[data-problem='" + hash + "']").addClass("q-selected");
            }

            _this.container.find(".problem-row td").click((e) => {
                var $tr = $(e.target).parent("tr.problem-row");
                _this.container.find(".problem-row").removeClass("q-selected");
                $tr.addClass("q-selected");
                var problem_key = $tr.data("problem");
                location.hash = "#" + problem_key;
            });

        });
    }
}

$(function(){

    const status_view = new StatusView('#status-container');
    const problem_list_view = new ProblemListView('#problem-list-container');

    status_view.on('refresh', ()=>{problem_list_view.refresh()});

    $(window).on('hashchange', function(){
        var hash = location.hash.replace("#", "");
        if(hash == ""){
            status_view.show_system();
        }else{
            status_view.show_problem(hash);
        }
        problem_list_view.refresh();
    }).trigger('hashchange');

});

