// ==============================================================
// File generated by Vivado(TM) HLS - High-Level Synthesis from C, C++ and SystemC
// Version: 2018.2
// Copyright (C) 1986-2018 Xilinx, Inc. All Rights Reserved.
// 
// ==============================================================

`timescale 1ns/1ps
module pynqrouter_AXI4LS_s_axi
#(parameter
    C_S_AXI_ADDR_WIDTH = 18,
    C_S_AXI_DATA_WIDTH = 32
)(
    // axi4 lite slave signals
    input  wire                          ACLK,
    input  wire                          ARESET,
    input  wire                          ACLK_EN,
    input  wire [C_S_AXI_ADDR_WIDTH-1:0] AWADDR,
    input  wire                          AWVALID,
    output wire                          AWREADY,
    input  wire [C_S_AXI_DATA_WIDTH-1:0] WDATA,
    input  wire [C_S_AXI_DATA_WIDTH/8-1:0] WSTRB,
    input  wire                          WVALID,
    output wire                          WREADY,
    output wire [1:0]                    BRESP,
    output wire                          BVALID,
    input  wire                          BREADY,
    input  wire [C_S_AXI_ADDR_WIDTH-1:0] ARADDR,
    input  wire                          ARVALID,
    output wire                          ARREADY,
    output wire [C_S_AXI_DATA_WIDTH-1:0] RDATA,
    output wire [1:0]                    RRESP,
    output wire                          RVALID,
    input  wire                          RREADY,
    output wire                          interrupt,
    // user signals
    output wire                          ap_start,
    input  wire                          ap_done,
    input  wire                          ap_ready,
    input  wire                          ap_idle,
    input  wire [0:0]                    ap_return,
    input  wire [15:0]                   boardstr_address0,
    input  wire                          boardstr_ce0,
    input  wire                          boardstr_we0,
    input  wire [7:0]                    boardstr_d0,
    output wire [7:0]                    boardstr_q0,
    input  wire [15:0]                   boardstr_high_address0,
    input  wire                          boardstr_high_ce0,
    input  wire                          boardstr_high_we0,
    input  wire [7:0]                    boardstr_high_d0,
    output wire [31:0]                   seed_V,
    input  wire [31:0]                   status_V,
    input  wire                          status_V_ap_vld
);
//------------------------Address Info-------------------
// 0x00000 : Control signals
//           bit 0  - ap_start (Read/Write/COH)
//           bit 1  - ap_done (Read/COR)
//           bit 2  - ap_idle (Read)
//           bit 3  - ap_ready (Read)
//           bit 7  - auto_restart (Read/Write)
//           others - reserved
// 0x00004 : Global Interrupt Enable Register
//           bit 0  - Global Interrupt Enable (Read/Write)
//           others - reserved
// 0x00008 : IP Interrupt Enable Register (Read/Write)
//           bit 0  - Channel 0 (ap_done)
//           bit 1  - Channel 1 (ap_ready)
//           others - reserved
// 0x0000c : IP Interrupt Status Register (Read/TOW)
//           bit 0  - Channel 0 (ap_done)
//           bit 1  - Channel 1 (ap_ready)
//           others - reserved
// 0x00010 : Data signal of ap_return
//           bit 0  - ap_return[0] (Read)
//           others - reserved
// 0x30000 : Data signal of seed_V
//           bit 31~0 - seed_V[31:0] (Read/Write)
// 0x30004 : reserved
// 0x30008 : Data signal of status_V
//           bit 31~0 - status_V[31:0] (Read)
// 0x3000c : Control signal of status_V
//           bit 0  - status_V_ap_vld (Read/COR)
//           others - reserved
// 0x10000 ~
// 0x1ffff : Memory 'boardstr' (41472 * 8b)
//           Word n : bit [ 7: 0] - boardstr[4n]
//                    bit [15: 8] - boardstr[4n+1]
//                    bit [23:16] - boardstr[4n+2]
//                    bit [31:24] - boardstr[4n+3]
// 0x20000 ~
// 0x2ffff : Memory 'boardstr_high' (41472 * 8b)
//           Word n : bit [ 7: 0] - boardstr_high[4n]
//                    bit [15: 8] - boardstr_high[4n+1]
//                    bit [23:16] - boardstr_high[4n+2]
//                    bit [31:24] - boardstr_high[4n+3]
// (SC = Self Clear, COR = Clear on Read, TOW = Toggle on Write, COH = Clear on Handshake)

//------------------------Parameter----------------------
localparam
    ADDR_AP_CTRL            = 18'h00000,
    ADDR_GIE                = 18'h00004,
    ADDR_IER                = 18'h00008,
    ADDR_ISR                = 18'h0000c,
    ADDR_AP_RETURN_0        = 18'h00010,
    ADDR_SEED_V_DATA_0      = 18'h30000,
    ADDR_SEED_V_CTRL        = 18'h30004,
    ADDR_STATUS_V_DATA_0    = 18'h30008,
    ADDR_STATUS_V_CTRL      = 18'h3000c,
    ADDR_BOARDSTR_BASE      = 18'h10000,
    ADDR_BOARDSTR_HIGH      = 18'h1ffff,
    ADDR_BOARDSTR_HIGH_BASE = 18'h20000,
    ADDR_BOARDSTR_HIGH_HIGH = 18'h2ffff,
    WRIDLE                  = 2'd0,
    WRDATA                  = 2'd1,
    WRRESP                  = 2'd2,
    WRRESET                 = 2'd3,
    RDIDLE                  = 2'd0,
    RDDATA                  = 2'd1,
    RDRESET                 = 2'd2,
    ADDR_BITS         = 18;

//------------------------Local signal-------------------
    reg  [1:0]                    wstate = WRRESET;
    reg  [1:0]                    wnext;
    reg  [ADDR_BITS-1:0]          waddr;
    wire [31:0]                   wmask;
    wire                          aw_hs;
    wire                          w_hs;
    reg  [1:0]                    rstate = RDRESET;
    reg  [1:0]                    rnext;
    reg  [31:0]                   rdata;
    wire                          ar_hs;
    wire [ADDR_BITS-1:0]          raddr;
    // internal registers
    reg                           int_ap_idle;
    reg                           int_ap_ready;
    reg                           int_ap_done = 1'b0;
    reg                           int_ap_start = 1'b0;
    reg                           int_auto_restart = 1'b0;
    reg                           int_gie = 1'b0;
    reg  [1:0]                    int_ier = 2'b0;
    reg  [1:0]                    int_isr = 2'b0;
    reg  [0:0]                    int_ap_return;
    reg  [31:0]                   int_seed_V = 'b0;
    reg  [31:0]                   int_status_V = 'b0;
    reg                           int_status_V_ap_vld;
    // memory signals
    wire [13:0]                   int_boardstr_address0;
    wire                          int_boardstr_ce0;
    wire                          int_boardstr_we0;
    wire [3:0]                    int_boardstr_be0;
    wire [31:0]                   int_boardstr_d0;
    wire [31:0]                   int_boardstr_q0;
    wire [13:0]                   int_boardstr_address1;
    wire                          int_boardstr_ce1;
    wire                          int_boardstr_we1;
    wire [3:0]                    int_boardstr_be1;
    wire [31:0]                   int_boardstr_d1;
    wire [31:0]                   int_boardstr_q1;
    reg                           int_boardstr_read;
    reg                           int_boardstr_write;
    reg  [1:0]                    int_boardstr_shift;
    wire [13:0]                   int_boardstr_high_address0;
    wire                          int_boardstr_high_ce0;
    wire                          int_boardstr_high_we0;
    wire [3:0]                    int_boardstr_high_be0;
    wire [31:0]                   int_boardstr_high_d0;
    wire [31:0]                   int_boardstr_high_q0;
    wire [13:0]                   int_boardstr_high_address1;
    wire                          int_boardstr_high_ce1;
    wire                          int_boardstr_high_we1;
    wire [3:0]                    int_boardstr_high_be1;
    wire [31:0]                   int_boardstr_high_d1;
    wire [31:0]                   int_boardstr_high_q1;
    reg                           int_boardstr_high_read;
    reg                           int_boardstr_high_write;
    reg  [1:0]                    int_boardstr_high_shift;

//------------------------Instantiation------------------
// int_boardstr
pynqrouter_AXI4LS_s_axi_ram #(
    .BYTES    ( 4 ),
    .DEPTH    ( 10368 )
) int_boardstr (
    .clk0     ( ACLK ),
    .address0 ( int_boardstr_address0 ),
    .ce0      ( int_boardstr_ce0 ),
    .we0      ( int_boardstr_we0 ),
    .be0      ( int_boardstr_be0 ),
    .d0       ( int_boardstr_d0 ),
    .q0       ( int_boardstr_q0 ),
    .clk1     ( ACLK ),
    .address1 ( int_boardstr_address1 ),
    .ce1      ( int_boardstr_ce1 ),
    .we1      ( int_boardstr_we1 ),
    .be1      ( int_boardstr_be1 ),
    .d1       ( int_boardstr_d1 ),
    .q1       ( int_boardstr_q1 )
);
// int_boardstr_high
pynqrouter_AXI4LS_s_axi_ram #(
    .BYTES    ( 4 ),
    .DEPTH    ( 10368 )
) int_boardstr_high (
    .clk0     ( ACLK ),
    .address0 ( int_boardstr_high_address0 ),
    .ce0      ( int_boardstr_high_ce0 ),
    .we0      ( int_boardstr_high_we0 ),
    .be0      ( int_boardstr_high_be0 ),
    .d0       ( int_boardstr_high_d0 ),
    .q0       ( int_boardstr_high_q0 ),
    .clk1     ( ACLK ),
    .address1 ( int_boardstr_high_address1 ),
    .ce1      ( int_boardstr_high_ce1 ),
    .we1      ( int_boardstr_high_we1 ),
    .be1      ( int_boardstr_high_be1 ),
    .d1       ( int_boardstr_high_d1 ),
    .q1       ( int_boardstr_high_q1 )
);

//------------------------AXI write fsm------------------
assign AWREADY = (wstate == WRIDLE);
assign WREADY  = (wstate == WRDATA);
assign BRESP   = 2'b00;  // OKAY
assign BVALID  = (wstate == WRRESP);
assign wmask   = { {8{WSTRB[3]}}, {8{WSTRB[2]}}, {8{WSTRB[1]}}, {8{WSTRB[0]}} };
assign aw_hs   = AWVALID & AWREADY;
assign w_hs    = WVALID & WREADY;

// wstate
always @(posedge ACLK) begin
    if (ARESET)
        wstate <= WRRESET;
    else if (ACLK_EN)
        wstate <= wnext;
end

// wnext
always @(*) begin
    case (wstate)
        WRIDLE:
            if (AWVALID)
                wnext = WRDATA;
            else
                wnext = WRIDLE;
        WRDATA:
            if (WVALID)
                wnext = WRRESP;
            else
                wnext = WRDATA;
        WRRESP:
            if (BREADY)
                wnext = WRIDLE;
            else
                wnext = WRRESP;
        default:
            wnext = WRIDLE;
    endcase
end

// waddr
always @(posedge ACLK) begin
    if (ACLK_EN) begin
        if (aw_hs)
            waddr <= AWADDR[ADDR_BITS-1:0];
    end
end

//------------------------AXI read fsm-------------------
assign ARREADY = (rstate == RDIDLE);
assign RDATA   = rdata;
assign RRESP   = 2'b00;  // OKAY
assign RVALID  = (rstate == RDDATA) & !int_boardstr_read & !int_boardstr_high_read;
assign ar_hs   = ARVALID & ARREADY;
assign raddr   = ARADDR[ADDR_BITS-1:0];

// rstate
always @(posedge ACLK) begin
    if (ARESET)
        rstate <= RDRESET;
    else if (ACLK_EN)
        rstate <= rnext;
end

// rnext
always @(*) begin
    case (rstate)
        RDIDLE:
            if (ARVALID)
                rnext = RDDATA;
            else
                rnext = RDIDLE;
        RDDATA:
            if (RREADY & RVALID)
                rnext = RDIDLE;
            else
                rnext = RDDATA;
        default:
            rnext = RDIDLE;
    endcase
end

// rdata
always @(posedge ACLK) begin
    if (ACLK_EN) begin
        if (ar_hs) begin
            rdata <= 1'b0;
            case (raddr)
                ADDR_AP_CTRL: begin
                    rdata[0] <= int_ap_start;
                    rdata[1] <= int_ap_done;
                    rdata[2] <= int_ap_idle;
                    rdata[3] <= int_ap_ready;
                    rdata[7] <= int_auto_restart;
                end
                ADDR_GIE: begin
                    rdata <= int_gie;
                end
                ADDR_IER: begin
                    rdata <= int_ier;
                end
                ADDR_ISR: begin
                    rdata <= int_isr;
                end
                ADDR_AP_RETURN_0: begin
                    rdata <= int_ap_return[0:0];
                end
                ADDR_SEED_V_DATA_0: begin
                    rdata <= int_seed_V[31:0];
                end
                ADDR_STATUS_V_DATA_0: begin
                    rdata <= int_status_V[31:0];
                end
                ADDR_STATUS_V_CTRL: begin
                    rdata[0] <= int_status_V_ap_vld;
                end
            endcase
        end
        else if (int_boardstr_read) begin
            rdata <= int_boardstr_q1;
        end
        else if (int_boardstr_high_read) begin
            rdata <= int_boardstr_high_q1;
        end
    end
end


//------------------------Register logic-----------------
assign interrupt = int_gie & (|int_isr);
assign ap_start  = int_ap_start;
assign seed_V    = int_seed_V;
// int_ap_start
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_start <= 1'b0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_AP_CTRL && WSTRB[0] && WDATA[0])
            int_ap_start <= 1'b1;
        else if (ap_ready)
            int_ap_start <= int_auto_restart; // clear on handshake/auto restart
    end
end

// int_ap_done
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_done <= 1'b0;
    else if (ACLK_EN) begin
        if (ap_done)
            int_ap_done <= 1'b1;
        else if (ar_hs && raddr == ADDR_AP_CTRL)
            int_ap_done <= 1'b0; // clear on read
    end
end

// int_ap_idle
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_idle <= 1'b0;
    else if (ACLK_EN) begin
            int_ap_idle <= ap_idle;
    end
end

// int_ap_ready
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_ready <= 1'b0;
    else if (ACLK_EN) begin
            int_ap_ready <= ap_ready;
    end
end

// int_auto_restart
always @(posedge ACLK) begin
    if (ARESET)
        int_auto_restart <= 1'b0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_AP_CTRL && WSTRB[0])
            int_auto_restart <=  WDATA[7];
    end
end

// int_gie
always @(posedge ACLK) begin
    if (ARESET)
        int_gie <= 1'b0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_GIE && WSTRB[0])
            int_gie <= WDATA[0];
    end
end

// int_ier
always @(posedge ACLK) begin
    if (ARESET)
        int_ier <= 1'b0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_IER && WSTRB[0])
            int_ier <= WDATA[1:0];
    end
end

// int_isr[0]
always @(posedge ACLK) begin
    if (ARESET)
        int_isr[0] <= 1'b0;
    else if (ACLK_EN) begin
        if (int_ier[0] & ap_done)
            int_isr[0] <= 1'b1;
        else if (w_hs && waddr == ADDR_ISR && WSTRB[0])
            int_isr[0] <= int_isr[0] ^ WDATA[0]; // toggle on write
    end
end

// int_isr[1]
always @(posedge ACLK) begin
    if (ARESET)
        int_isr[1] <= 1'b0;
    else if (ACLK_EN) begin
        if (int_ier[1] & ap_ready)
            int_isr[1] <= 1'b1;
        else if (w_hs && waddr == ADDR_ISR && WSTRB[0])
            int_isr[1] <= int_isr[1] ^ WDATA[1]; // toggle on write
    end
end

// int_ap_return
always @(posedge ACLK) begin
    if (ARESET)
        int_ap_return <= 0;
    else if (ACLK_EN) begin
        if (ap_done)
            int_ap_return <= ap_return;
    end
end

// int_seed_V[31:0]
always @(posedge ACLK) begin
    if (ARESET)
        int_seed_V[31:0] <= 0;
    else if (ACLK_EN) begin
        if (w_hs && waddr == ADDR_SEED_V_DATA_0)
            int_seed_V[31:0] <= (WDATA[31:0] & wmask) | (int_seed_V[31:0] & ~wmask);
    end
end

// int_status_V
always @(posedge ACLK) begin
    if (ARESET)
        int_status_V <= 0;
    else if (ACLK_EN) begin
        if (status_V_ap_vld)
            int_status_V <= status_V;
    end
end

// int_status_V_ap_vld
always @(posedge ACLK) begin
    if (ARESET)
        int_status_V_ap_vld <= 1'b0;
    else if (ACLK_EN) begin
        if (status_V_ap_vld)
            int_status_V_ap_vld <= 1'b1;
        else if (ar_hs && raddr == ADDR_STATUS_V_CTRL)
            int_status_V_ap_vld <= 1'b0; // clear on read
    end
end


//------------------------Memory logic-------------------
// boardstr
assign int_boardstr_address0      = boardstr_address0 >> 2;
assign int_boardstr_ce0           = boardstr_ce0;
assign int_boardstr_we0           = boardstr_we0;
assign int_boardstr_be0           = 1 << boardstr_address0[1:0];
assign int_boardstr_d0            = {4{boardstr_d0}};
assign boardstr_q0                = int_boardstr_q0 >> (int_boardstr_shift * 8);
assign int_boardstr_address1      = ar_hs? raddr[15:2] : waddr[15:2];
assign int_boardstr_ce1           = ar_hs | (int_boardstr_write & WVALID);
assign int_boardstr_we1           = int_boardstr_write & WVALID;
assign int_boardstr_be1           = WSTRB;
assign int_boardstr_d1            = WDATA;
// boardstr_high
assign int_boardstr_high_address0 = boardstr_high_address0 >> 2;
assign int_boardstr_high_ce0      = boardstr_high_ce0;
assign int_boardstr_high_we0      = boardstr_high_we0;
assign int_boardstr_high_be0      = 1 << boardstr_high_address0[1:0];
assign int_boardstr_high_d0       = {4{boardstr_high_d0}};
assign int_boardstr_high_address1 = ar_hs? raddr[15:2] : waddr[15:2];
assign int_boardstr_high_ce1      = ar_hs | (int_boardstr_high_write & WVALID);
assign int_boardstr_high_we1      = int_boardstr_high_write & WVALID;
assign int_boardstr_high_be1      = WSTRB;
assign int_boardstr_high_d1       = WDATA;
// int_boardstr_read
always @(posedge ACLK) begin
    if (ARESET)
        int_boardstr_read <= 1'b0;
    else if (ACLK_EN) begin
        if (ar_hs && raddr >= ADDR_BOARDSTR_BASE && raddr <= ADDR_BOARDSTR_HIGH)
            int_boardstr_read <= 1'b1;
        else
            int_boardstr_read <= 1'b0;
    end
end

// int_boardstr_write
always @(posedge ACLK) begin
    if (ARESET)
        int_boardstr_write <= 1'b0;
    else if (ACLK_EN) begin
        if (aw_hs && AWADDR[ADDR_BITS-1:0] >= ADDR_BOARDSTR_BASE && AWADDR[ADDR_BITS-1:0] <= ADDR_BOARDSTR_HIGH)
            int_boardstr_write <= 1'b1;
        else if (WVALID)
            int_boardstr_write <= 1'b0;
    end
end

// int_boardstr_shift
always @(posedge ACLK) begin
    if (ACLK_EN) begin
        if (boardstr_ce0)
            int_boardstr_shift <= boardstr_address0[1:0];
    end
end

// int_boardstr_high_read
always @(posedge ACLK) begin
    if (ARESET)
        int_boardstr_high_read <= 1'b0;
    else if (ACLK_EN) begin
        if (ar_hs && raddr >= ADDR_BOARDSTR_HIGH_BASE && raddr <= ADDR_BOARDSTR_HIGH_HIGH)
            int_boardstr_high_read <= 1'b1;
        else
            int_boardstr_high_read <= 1'b0;
    end
end

// int_boardstr_high_write
always @(posedge ACLK) begin
    if (ARESET)
        int_boardstr_high_write <= 1'b0;
    else if (ACLK_EN) begin
        if (aw_hs && AWADDR[ADDR_BITS-1:0] >= ADDR_BOARDSTR_HIGH_BASE && AWADDR[ADDR_BITS-1:0] <= ADDR_BOARDSTR_HIGH_HIGH)
            int_boardstr_high_write <= 1'b1;
        else if (WVALID)
            int_boardstr_high_write <= 1'b0;
    end
end

// int_boardstr_high_shift
always @(posedge ACLK) begin
    if (ACLK_EN) begin
        if (boardstr_high_ce0)
            int_boardstr_high_shift <= boardstr_high_address0[1:0];
    end
end


endmodule


`timescale 1ns/1ps

module pynqrouter_AXI4LS_s_axi_ram
#(parameter
    BYTES  = 4,
    DEPTH  = 256,
    AWIDTH = log2(DEPTH)
) (
    input  wire               clk0,
    input  wire [AWIDTH-1:0]  address0,
    input  wire               ce0,
    input  wire               we0,
    input  wire [BYTES-1:0]   be0,
    input  wire [BYTES*8-1:0] d0,
    output reg  [BYTES*8-1:0] q0,
    input  wire               clk1,
    input  wire [AWIDTH-1:0]  address1,
    input  wire               ce1,
    input  wire               we1,
    input  wire [BYTES-1:0]   be1,
    input  wire [BYTES*8-1:0] d1,
    output reg  [BYTES*8-1:0] q1
);
//------------------------Local signal-------------------
reg  [BYTES*8-1:0] mem[0:DEPTH-1];
//------------------------Task and function--------------
function integer log2;
    input integer x;
    integer n, m;
begin
    n = 1;
    m = 2;
    while (m < x) begin
        n = n + 1;
        m = m * 2;
    end
    log2 = n;
end
endfunction
//------------------------Body---------------------------
// read port 0
always @(posedge clk0) begin
    if (ce0) q0 <= mem[address0];
end

// read port 1
always @(posedge clk1) begin
    if (ce1) q1 <= mem[address1];
end

genvar i;
generate
    for (i = 0; i < BYTES; i = i + 1) begin : gen_write
        // write port 0
        always @(posedge clk0) begin
            if (ce0 & we0 & be0[i]) begin
                mem[address0][8*i+7:8*i] <= d0[8*i+7:8*i];
            end
        end
        // write port 1
        always @(posedge clk1) begin
            if (ce1 & we1 & be1[i]) begin
                mem[address1][8*i+7:8*i] <= d1[8*i+7:8*i];
            end
        end
    end
endgenerate

endmodule

