/**
 * router.hpp
 *
 * for Vivado HLS
 */

#ifndef __ROUTER_HPP__
#define __ROUTER_HPP__

#ifdef SOFTWARE
#include "ap_int.h"
#else
#include <ap_int.h>
#endif

//#define DEBUG_PRINT // for debug

#ifdef DEBUG_PRINT
using namespace std;
#endif

// Parameters
#define MAX_WIDTH   72      // Max of X, Y
#define BITWIDTH_XY 13
#define BITMASK_XY  65528   // 1111 1111 1111 1000
#define MAX_LAYER   8       // Max of Z
#define BITWIDTH_Z  3
#define BITMASK_Z   7       // 0000 0000 0000 0111

#define MAX_CELLS	41472    // Max #cells (16bit)
#define MAX_LINES	1024     // Max #lines (10bit)
#define MAX_PQ		32768    // Queue size (15bit)
#define MAX_BUFFER	16384    // Line buffer size (14bit)
#define CELL_BIT	16
#define LINE_BIT	10
#define PQ_BIT		15
#define BUFF_BIT	14

#define PQ_PRIORITY_WIDTH 16
#define PQ_PRIORITY_MASK  65535       // 0000 0000 0000 0000 1111 1111 1111 1111
#define PQ_DATA_WIDTH     16
#define PQ_DATA_MASK      4294901760  // 1111 1111 1111 1111 0000 0000 0000 0000

#define MAX_WEIGHT	255      // Max weight
#define BOARDSTR_SIZE 41472  // Size of I/O

ap_uint<8> new_weight(ap_uint<16> x);
bool pynqrouter(char boardstr[BOARDSTR_SIZE], ap_uint<32> seed, ap_int<32> *status);

ap_uint<7> abs_uint7(ap_uint<7> a, ap_uint<7> b);
ap_uint<3> abs_uint3(ap_uint<3> a, ap_uint<3> b);
ap_uint<BUFF_BIT> search(ap_uint<BUFF_BIT> idx, ap_uint<CELL_BIT> paths[MAX_BUFFER], ap_uint<CELL_BIT> start, ap_uint<CELL_BIT> goal, ap_uint<8> w[MAX_WEIGHT]);
void pq_push(ap_uint<32> pq_nodes[MAX_PQ], ap_uint<16> priority, ap_uint<16> data, ap_uint<PQ_BIT> *pq_len, bool *is_empty);
void pq_pop(ap_uint<32> pq_nodes[MAX_PQ], ap_uint<16> *ret_priority, ap_uint<16> *ret_data, ap_uint<PQ_BIT> *pq_len, bool *is_empty);

#endif /* __ROUTER_HPP__ */
