/* solver.c */
/* Last Change: 2018/08/26 (Sun) 23:31:34. */

#define MAX_ATTEMPS 100000

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
/* #include<limits.h> */
/* #include<math.h> */
#include<time.h>

int board[8][72][72]={};
int avail[8][72][72]={}; //start=3,path=2,avail=1,nonavail=0,goal=-1
int connected[8*72*72/2+1]={}; //connected[0]=(number of connected lines)
int depth,height,width;
int goalx,goaly,goalz;
int lines;
//z,y,x

void read(void){ //read problem
	int x,y,z,i;
	char c,str[8];
	scanf(" %s",str); //SIZE
	scanf(" %d",&width);
	if(width>72||width<=0)
		printf("Error: width\n");
	scanf(" %c",&c); //X
	scanf(" %d",&height);
	if(height>72||height<=0)
		printf("Error: height\n");
	scanf(" %c",&c); //X
	scanf(" %d",&depth);
	if(depth>8||depth<=0)
		printf("Error: depth\n");
	scanf(" %s",str); //LINE_NUM
	scanf(" %d",&lines);
	if(lines<=0)
		printf("Error: lines\n");
	for(i=1;i<=lines;i++){
		scanf(" %s",str); //LINE#X
		scanf(" %c",&c); //(
		scanf(" %d",&x);
		if(x>=72||x<0)
			printf("Error: x\n");
		scanf(" %c",&c); //,
		scanf(" %d",&y);
		if(y>=72||y<0)
			printf("Error: y\n");
		scanf(" %c",&c); //,
		scanf(" %d",&z);
		if(z>=72||z<0)
			printf("Error: z\n");
		scanf(" %c",&c); //)
		board[z-1][y][x]=-i;
		scanf("%c",&c); //)
		/* scanf(" %[ -]",&c); //space or - */
		scanf(" %c",&c); //(
		scanf(" %d",&x);
		if(x>=72||x<0)
			printf("Error: x\n");
		scanf(" %c",&c); //,
		scanf(" %d",&y);
		if(y>=72||y<0)
			printf("Error: y\n");
		scanf(" %c",&c); //,
		scanf(" %d",&z);
		if(z>=72||z<0)
			printf("Error: z\n");
		scanf(" %c",&c); //)
		board[z-1][y][x]=-i;
	}
	return;
}

int randline(void){ //return random line number
	return rand()%lines+1;
}

void shuffle(int array[],int start,int end){
	int i,j,t;
	if(end==start)
		return;
	for(i=start;i<end;i++){
		j=start+rand()%(end-start);
		t=array[i];
		array[i]=array[j];
		array[j]=t;
	}
}

int available(int nowx,int nowy, int nowz,int flag){ //return 1 when (nowx,nowy,nowz) can be connected to goal
	if(avail[nowz][nowy][nowx]==-1) //goal
		return 1;
	if(avail[nowz][nowy][nowx]!=1&&flag==0)
		return 0;
	int isbranch=-1;
	if(nowx>0&&avail[nowz][nowy][nowx-1]>=2)
		isbranch++;
	if(nowy>0&&avail[nowz][nowy-1][nowx]>=2)
		isbranch++;
	if(nowz>0&&avail[nowz-1][nowy][nowx]>=2)
		isbranch++;
	if(nowx<width-1&&avail[nowz][nowy][nowx+1]>=2)
		isbranch++;
	if(nowy<height-1&&avail[nowz][nowy+1][nowx]>=2)
		isbranch++;
	if(nowz<depth-1&&avail[nowz+1][nowy][nowx]>=2)
		isbranch++;
	if(isbranch>0){
		avail[nowz][nowy][nowx]=1;
		return 0;
	}
	if(avail[nowz][nowy][nowx]==1)
		avail[nowz][nowy][nowx]=2;
	int i,src=0;
	int searchorder[6]; //x+-,y+-,z+-
	/* for(i=0;i<6;i++) */
	/* searchorder[i]=-1; */
	if(nowx>goalx){
		searchorder[src]=0;
		src++;
	}else
		searchorder[5+src]=0;
	if(nowy>goaly){
		searchorder[src]=1;
		src++;
	}else
		searchorder[4+src]=1;
	if(nowz>goalz){
		searchorder[src]=2;
		src++;
	}else
		searchorder[3+src]=2;
	if(nowx<goalx){
		searchorder[src]=3;
		src++;
	}else
		searchorder[2+src]=3;
	if(nowy<goaly){
		searchorder[src]=4;
		src++;
	}else
		searchorder[1+src]=4;
	if(nowz<goalz){
		searchorder[src]=5;
		src++;
	}else
		searchorder[src]=5;
	/* shuffle(searchorder,0,src); */
	/* shuffle(searchorder,src,6); */
	int j,t;
	for(i=0;i<src;i++){
		j=rand()%(src);
		t=searchorder[i];
		searchorder[i]=searchorder[j];
		searchorder[j]=t;
	}
	for(i=src;i<6;i++){
		j=src+rand()%(6-src);
		t=searchorder[i];
		searchorder[i]=searchorder[j];
		searchorder[j]=t;
	}
	/* for(i=0;i<6;i++) */
	/* 	printf("%d ",searchorder[i]); */
	/* printf("\n"); */
	for(i=0;i<6;i++)
		switch(searchorder[i]){
			case 0:
				if(nowx>0&&available(nowx-1,nowy,nowz,0))
					return 1;
				break;
			case 1:
				if(nowy>0&&available(nowx,nowy-1,nowz,0))
					return 1;
				break;
			case 2:
				if(nowz>0&&available(nowx,nowy,nowz-1,0))
					return 1;
				break;
			case 3:
				if(nowx<width-1&&available(nowx+1,nowy,nowz,0))
					return 1;
				break;
			case 4:
				if(nowy<height-1&&available(nowx,nowy+1,nowz,0))
					return 1;
				break;
			case 5:
				if(nowz<depth-1&&available(nowx,nowy,nowz+1,0))
					return 1;
				break;
			default:
				break;
		}
	if(avail[nowz][nowy][nowx]==2)
		avail[nowz][nowy][nowx]=1;
	return 0;
}

int connectable(int linea,int lineb){ //return 1 if linea can be connected when lineb is deleted
	int startx=-1,starty=-1,startz=-1,notfound=1;
	int i,j,k;
	for(i=0;i<depth;i++)
		for(j=0;j<height;j++)
			for(k=0;k<width;k++)
				if(board[i][j][k]==linea*(-1)){
					if(notfound){ //start
						startz=i;
						starty=j;
						startx=k;
						avail[i][j][k]=3;
						notfound=0;
					}else{ //goal
						goalz=i;
						goaly=j;
						goalx=k;
						avail[i][j][k]=-1;
						notfound=2;
					}
				}else if(board[i][j][k]==0||board[i][j][k]==lineb||board[i][j][k]==linea){
					avail[i][j][k]=1;
				}else{
					avail[i][j][k]=0;
				}
	if(startx==-1||starty==-1||startz==-1||notfound!=2){
		printf("Error: Line %d\n",linea);
		return 0;
	}
	return available(startx,starty,startz,1);
}

void connect(int line){ //connect line
	int i,j,k;
	for(i=0;i<depth;i++)
		for(j=0;j<height;j++)
			for(k=0;k<width;k++)
				if(avail[i][j][k]==2){
					if(board[i][j][k]==0)
						board[i][j][k]=line;
					else
						printf("something wrong");
				}
	return;
}

void delete(int line){ //delete line
	int i,j,k;
	for(i=0;i<depth;i++)
		for(j=0;j<height;j++)
			for(k=0;k<width;k++)
				if(board[i][j][k]==line)
					board[i][j][k]=0;
	return;
}

int solve(void){ //return 1 when solved, 0 when cannot
	int i,j,linea,lineb;
	for(i=0;i<MAX_ATTEMPS;i++){ //try to connect MAX_ATTEMPS times
		linea=randline();
		if(connected[linea])
			continue;
		if(connectable(linea,0)){ //if linea canbe conneced without deleting lines
			connect(linea);
			connected[linea]=1;
			connected[0]++;
			if(connected[0]==lines)
				return 1;
		}
		else{
			for(j=0;j<MAX_ATTEMPS;j++){ //try to find a line to delete
				lineb=randline();
				if(connectable(linea,lineb)){
					delete(lineb);
					connect(linea);
					connected[linea]=1;
					connected[lineb]=0;
					break;
				}
				if(j==MAX_ATTEMPS-1)
					return 0;
			}
		}
	}
	return 0;
}

void write(void){
	int i,j,k;
	printf("SIZE %dX%dX%d\n",width,height,depth);
	for(k=0;k<depth;k++){
		printf("LAYER %d\n",k+1);
		for(j=0;j<height;j++){
			for(i=0;i<width-1;i++){
				if(board[k][j][i]<0)
					board[k][j][i]=-board[k][j][i];
				printf("%d, ",board[k][j][i]);
			}
			if(board[k][j][i]<0)
				board[k][j][i]=-board[k][j][i];
			printf("%d",board[k][j][i]);
			printf("\n");
		}
	}
	return;
}

int main(void){
	srand((unsigned)time(NULL));
	read();
	if(solve())
		write();
	else
		printf("Cannot solve!\n");
	return 0;
}
