#!/usr/bin/env python3
"""
This script provides a PYNQ client.
This is intended to run on the client server (PYNQ).
"""

import argparse
import json
import os
import platform
import requests
import sys
import threading
import time
from flask import Flask, render_template, request, g
from urllib.parse import urlparse

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../../solver')
import BoardStr

import Solver2017
import Solver2018

app = Flask(__name__)
args = {}
client_baseurl = ""
pynqrouter = None

@app.route('/start', methods=["POST"])
def start():

    global args
    global client_baseurl
    global pynqrouter

    ans = {"status": "None", "answer": "", "client": client_baseurl}

    if args["verbose"]:
        print(request.form)

    if pynqrouter.solver_thread is not None:
        pynqrouter.stop_solver()

    if pynqrouter.solver_thread is None:
        qstr = request.form["question"]
        qname = request.form["qname"]
        qseed = request.form["qseed"]
	
        boardstr = BoardStr.conv_boardstr(qstr.split('\n'), 'random', int(qseed))
        option = {
            "name": qname,
            "host": args['host'],
            "client": client_baseurl,
            "problem": qstr,
            "req_id": request.form['req_id'],
            "resolver": request.form['resolver']
        }

        print(option['req_id'])

        pynqrouter.start_solver(boardstr, qseed, option)

        # 実行だけ開始する
        ans["status"] = "Processing"

    else:
        ans = {"status": "Not ready", "answer": ""}

    if args["verbose"]:
        print(ans)

    return json.dumps(ans)

@app.route('/stop')
def stop():

    global pynqrouter

    if pynqrouter.solver_thread is None:
        ans = {"status": "No threads"}
    else:
        # pynq_thread.stop()
        pynqrouter.stop_solver()
        ans = {"status": "Stopped"}

    return json.dumps(ans)

@app.route("/status")
def status():

    global pynqrouter

    res_mes = ""

    if pynqrouter.solver_thread is None:
        res_mes = "Ready"
    else:
        res_mes = "Working"

    res = {"status": res_mes}
    return json.dumps(res)

@app.route("/")
def index():
    return platform.node()

@app.before_request
def before_request():
    global client_baseurl

    _url = request.url
    parse = urlparse(_url)
    client_baseurl = parse.netloc

if __name__ == "__main__":

    # Check if this script runs as "root" user
    if os.getuid() != 0:
        raise Exception("Must run as root")
        sys.exit(1)

    parser = argparse.ArgumentParser(description="PYNQ client.")
    parser.add_argument("-p", "--port", action="store", type=int, default=5000, help="Port")
    parser.add_argument("-H", "--host", action="store", type=str, default="192.168.5.1:5000", help="Host address")
    parser.add_argument("-s", "--solver", action="store", type=str, default="2017", help="2017, 2018, 2018Ultra, 2018Ishi")
    parser.add_argument("--debug", action="store_true", default=False, help="Debug mode.")
    parser.add_argument("-v", "--verbose", action="store_true", default=False, help="Verbose.")
    args = vars(parser.parse_args())

    if args['solver'] == '2017':
        pynqrouter = Solver2017
    elif args['solver'] == '2018':
        pynqrouter = Solver2018
    elif args['solver'] == '2018Ultra':
        raise NotImplementedError()
    elif args['solver'] == '2018Ishi':
        raise NotImplementedError()
    else:
        pynqrouter = Solver2017

    if args["debug"]:
        app.debug = True
    app.run(host='0.0.0.0', port=args["port"], threaded=True)

