#!/usr/bin/env python3

import subprocess

PYTHON2 = "/usr/bin/python"
ADCCLI = "/home/pi/adc2018/conmgr/client/adccli"

def _exec_adccli(cmd):
    exec_cmd = "{} {} {}".format(PYTHON2, ADCCLI, cmd).strip()
    print("ADCCLI: {}".format(exec_cmd))
    p = subprocess.run(exec_cmd, stdout=subprocess.PIPE, shell=True)
    res = p.stdout.decode().strip()
    print(res)
    return res

def login(url, username, password):
    cmd = "--URL='{}' --username='{}' --password='{}' login".format(url, username, password)
    return _exec_adccli(cmd)

def logout():
    cmd = "logout"
    return _exec_adccli(cmd)

def whoami():
    cmd = "whoami"
    return _exec_adccli(cmd)

def put_message(message):
    cmd = "put-user-alive '{}'"
    return _exec_adccli(cmd)

def post_user_q(qnum, filepath):
    cmd = "post-user-q {} {}".format(qnum, filepath)
    return _exec_adccli(cmd)

def get_q_all(outpath):
    cmd = "get-q"
    question_list = _exec_adccli(cmd).split("\n")

    print("--- ADCCLI questions ---")
    print(question_list)

    for v in question_list:
        if v.startswith("Q"):
            qnumber = int(v.replace("Q", ""))
            out_file_path = "{}/NL_Q{:02d}.txt".format(outpath, qnumber)
            cmd = "--output {} get-q {}".format(out_file_path, qnumber)
            r = _exec_adccli(cmd)

    return question_list

def put_a(qnum, filepath):
    cmd = "put-a {} {}".format(qnum, filepath)
    return _exec_adccli(cmd)

def put_a_info(qnum, cpu, mem, misc):
    cmd = "put-a-info {} {} {} '{}'".format(qnum, cpu, mem, misc)
    return _exec_adccli(cmd)

