/* solver.c */
/* Last Change: 2018/08/26 (Sun) 05:44:44. */

#define MAX_ATTEMPS 1000000

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
/* #include<limits.h> */
/* #include<math.h> */
#include<time.h>

int board[8][72][72]={};
int avail[8][72][72]={}; //start=3,path=2,avail=1,nonavail=0,goal=-1
int connected[8*72*72/2+1]={};
int depth,height,width;
int lines;
int searchorder[6];
//z,y,x

void read(void){
	int x,y,z,i;
	char c,str[8];
	scanf(" %s",str); //SIZE
	scanf(" %d",&width);
	if(width>72||width<=0)
		printf("Error: width\n");
	scanf(" %c",&c); //X
	scanf(" %d",&height);
	if(height>72||height<=0)
		printf("Error: height\n");
	scanf(" %c",&c); //X
	scanf(" %d",&depth);
	if(depth>8||depth<=0)
		printf("Error: depth\n");
	scanf(" %s",str); //LINE_NUM
	scanf(" %d",&lines);
	if(lines<=0)
		printf("Error: lines\n");
	for(i=1;i<=lines;i++){
		scanf(" %s",str); //LINE#X
		scanf(" %c",&c); //(
		scanf(" %d",&x);
		if(x>=72||x<0)
			printf("Error: x\n");
		scanf(" %c",&c); //,
		scanf(" %d",&y);
		if(y>=72||y<0)
			printf("Error: y\n");
		scanf(" %c",&c); //,
		scanf(" %d",&z);
		if(z>=72||z<0)
			printf("Error: z\n");
		scanf(" %c",&c); //)
		board[z-1][y][x]=-i;
		scanf("%c",&c); //)
		/* scanf(" %[ -]",&c); //space or - */
		scanf(" %c",&c); //(
		scanf(" %d",&x);
		if(x>=72||x<0)
			printf("Error: x\n");
		scanf(" %c",&c); //,
		scanf(" %d",&y);
		if(y>=72||y<0)
			printf("Error: y\n");
		scanf(" %c",&c); //,
		scanf(" %d",&z);
		if(z>=72||z<0)
			printf("Error: z\n");
		scanf(" %c",&c); //)
		board[z-1][y][x]=-i;
	}
	return;
}

int randline(void){ //1-lines -> 1-lines
	return rand()%lines+1;
}

int available(int startx,int starty, int startz){
	if(avail[startz][starty][startx]==-1) //goal
		return 1;
	if(avail[startz][starty][startx]==2||avail[startz][starty][startx]==3) //visited
		return 0;
	avail[startz][starty][startx]=2;
	int i,j,k;
	for(i=0;i<6;i++){
		j=rand()%6;
		k=searchorder[i];
		searchorder[i]=searchorder[j];
		searchorder[j]=k;
	}
	for(i=0;i<6;i++)
		switch(searchorder[i]){
			case 0:
				if(startx>0&&available(startx-1,starty,startz))
					return 1;
			case 1:
				if(starty>0&&available(startx,starty-1,startz))
					return 1;
			case 2:
				if(startz>0&&available(startx,starty,startz-1))
					return 1;
			case 3:
				if(startx<depth&&available(startx+1,starty,startz))
					return 1;
			case 4:
				if(starty<height&&available(startx,starty+1,startz))
					return 1;
			case 5:
				if(startz<width&&available(startx,starty,startz+1))
					return 1;
		}
	return 0;
}

int connectable(int linea,int lineb){
	int startx=-1,starty=-1,startz=-1,notfound=1;
	int i,j,k;
	for(i=0;i<depth;i++)
		for(j=0;j<height;j++)
			for(k=0;k<width;k++)
				if(board[i][j][k]==linea*(-1)){
					if(notfound){
						notfound=0;
						startz=i;
						starty=j;
						startx=k;
						avail[startz][starty][startx]=3;
					}else{
						avail[i][j][k]=-1; //goal
					}
				}else if(board[i][j][k]==0||board[i][j][k]==lineb||board[i][j][k]==linea){
					avail[i][j][k]=1;
				}else{
					avail[i][j][k]=0;
				}
	if(startx==-1||starty==-1||startz==-1){
		printf("Error: Line %d\n",linea);
		return 0;
	}
	return available(startx,starty,startz);
}

void connect(int num){
	int i,j,k;
	for(i=0;i<depth;i++)
		for(j=0;j<height;j++)
			for(k=0;k<width;k++)
				if(avail[i][j][k]==2&&board[i][j][k]==0)
					board[i][j][k]=num;
	return;
}

void delete(int line){
	int i,j,k;
	for(i=0;i<depth;i++)
		for(j=0;j<height;j++)
			for(k=0;k<width;k++)
				if(board[i][j][k]==line)
					board[i][j][k]=0;
	return;
}

int solve(void){ //return 1 when solved, 0 when cannot
	int i,j,linea,lineb;
	for(i=0;i<MAX_ATTEMPS;i++){
		linea=randline();
		if(connected[linea])
			continue;
		if(connectable(linea,0)){
			connect(linea);
			connected[linea]=1;
			connected[0]++;
			if(connected[0]==lines)
				return 1;
		}
		else{
			for(j=0;j<MAX_ATTEMPS;j++){
				lineb=randline();
				if(connectable(linea,lineb)){
					delete(lineb);
					connect(linea);
					connected[linea]=1;
					connected[lineb]=0;
					break;
				}
				if(j==MAX_ATTEMPS-1)
					return 0;
			}
		}
	}
	return 0;
}

void write(void){
	int i,j,k;
	printf("SIZE %dX%dX%d\n",width,height,depth);
	for(k=0;k<depth;k++){
		printf("LAYER %d\n",k+1);
		for(j=0;j<height;j++){
			for(i=0;i<width-1;i++){
				if(board[k][j][i]<0)
					board[k][j][i]=-board[k][j][i];
				printf("%d,",board[k][j][i]);
			}
			if(board[k][j][i]<0)
				board[k][j][i]=-board[k][j][i];
			printf("%d",board[k][j][i]);
			printf("\n");
		}
	}
	return;
}

int main(void){
	int i;
	srand((unsigned)time(NULL));
	read();
	for(i=0;i<6;i++)
		searchorder[i]=i;
	if(solve())
		write();
	else
		printf("Cannot solve!\n");
	return 0;
}

