/*
This script provides a PYNQ manager
*/

var PynqManager = (function(){
    "use strict";

    // Constructor
    var PynqManager = function(clients){

        if (!(this instanceof PynqManager)){
            return new PynqManager(clients);
        }

        this.clients = clients;
    }

    var _p = PynqManager.prototype;

    // Status check for clients
    _p.getStatus = function(){

        for (var key in this.clients){
            (function(_key, _client){
                var statusObj = $(".client-status-row[data-cname='"+_key+"']").find(".client-status-value").eq(0)
                $.ajax({
                    type: "POST",
                    url: "/status",
                    dataType: "json",
                    data: {
                        "client": _client
                    }
                }).done(function(res){
                    var answer = res["status"];
                    var message = "";

                    if (answer) {
                        message = answer;
                    }else{
                        message = "Illegal response: " + res;
                    }
                    statusObj.text(message);
                }).fail(function(){
                    statusObj.text("Connection error");
                });
            })(key, this.clients[key]);
        }

    }

    _p.sendQuestion = function(qname, after=null){

        $("#solving-question-name").text(qname);
        $("#solving-question-status").text('Processing');

        $.ajax({
            type: "POST",
            dataType: "json",
            url: "/start",
            data: {
                "qname": qname
            }
        }).done(function(res){
            var answer = res;
            $("#solving-question-status").text(answer["status"]);
            $("#solved-client").text(answer["answer"]["client"]);

            if (after !== null){
                after();
            }
        });

    }

    _p.sendStop = function(){

        console.log("Not implemented!");

    }

    return PynqManager;
})();


$(function(){

    var pynqClients = {}
    var pm = null;

    var refresh_question_table = function(){
        $.ajax({
            type: "GET",
            dataType: "html",
            url: "/get_question_table"
        }).done(function(d){
            $("#question-table-wrapper").find("#question-table").remove();
            $("#question-table-wrapper").html(d);

            $(".question-row td").click(function(){
                var $tr = $(this).parent("tr.question-row");
                $(".question-row").removeClass("q-selected");
                $tr.addClass("q-selected");
                var qname = $tr.data("qname");
                show_question_status(qname);
                return false;
            });
        });
    }

    var refresh_client_table = function(){
        $.ajax({
            type: "GET",
            dataType: "html",
            url: "/get_client_table"
        }).done(function(d){
            $("#client-control-pane").html("");
            $("#client-control-pane").html(d);

            $.ajax({
                type: "GET",
                dataType: "json",
                url: "/get_clients"
            }).done(function(d){
                pynqClients = d;
                pm = PynqManager(pynqClients);
                pm.getStatus();
            });
        });
    }

    var show_question_status = function(qname){
        $.ajax({
            type: "GET",
            dataType: "html",
            url: "/get_question_status",
            data: {qname: qname}
        }).done(function(d){
            $("#client-control-pane").html("");
            $("#client-control-pane").html(d);

            $("#client-control-pane").find(".start-button").eq(0).click(function(){
                var qname = $(this).data("qname");
                pm.sendQuestion(qname, after=refresh_question_table);
            });
        });
    }

    refresh_question_table();
    refresh_client_table();

    $("#view-server-status-button").click(function(){
        refresh_client_table();
        return false;
    });

});
