#!/usr/bin/env python3
"""
This script provides a PYNQ client.
This is intended to run on the client server (PYNQ).
"""

import argparse
import json
import os
import platform
import queue
import requests
import subprocess
import sys
import threading
import time
from flask import Flask, render_template, request, g
from urllib.parse import urlparse

sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../../solver')
import BoardStr
# import adc2018solver as pynqrouter

app = Flask(__name__)
args = {}
client_baseurl = ""
resolve_queue = None

def resolve():
    """
    queueを受け取りそこに入ってきた答えを整形し，ホストに送信します．
    """
    global args
    global client_baseurl
    global resolve_queue

    while True:
        if resolve_queue is None:
            time.sleep(1)
            continue
        else:
            data = resolve_queue.get()
            
            if args['verbose']:
                print("Processing queued data...")
                print(data)

            outpath = "./works/resolved.txt"
            probpath = "./problems/{}".format(data['qname'])
            tmppath = "./works/answer.txt"

            with open(tmppath, "w") as fp:
                fp.write(data['answer'])

            # Resolver
            cmd = "/home/pi/adc2017/pynq-router/resolver/solver --reroute --output {} {} {}".format(outpath, probpath, tmppath)
            subprocess.call(cmd.strip().split(" "))

            resolved = ""
            with open(outpath, "r") as fp:
                resolved = fp.read()

            res = {
                'answer': resolved,
                'solved': True,
                'solver': data['client'],
                'resolver': client_baseurl,
                'client': client_baseurl,
                'cputime': data['cputime'],
                'qname': data['qname']
            }
            # 結果をホストに返す
            r = requests.post("http://{}/post".format(args['host']), data=res)
            
            if args['verbose']:
                print("Done.")
                print(res)

@app.route('/post', methods=["POST"])
def start():

    # global pynq_thread
    global args
    global client_baseurl
    global resolve_queue

    if args["verbose"]:
        print(request.form)

    data = {
        'client': request.form['client'],
        'qname': request.form['qname'],
        'answer': request.form['answer'],
        'cputime': request.form['cputime']
    }

    resolve_queue.put(data)
    
    ans = {"status": "Queued"}

    if args["verbose"]:
        print(ans)

    return json.dumps(ans)

@app.route('/stop')
def stop():

    global resolve_queue

    if resolve_queue.empty() is None:
        ans = {"status": "Nothing queued"}
    else:
        # pynq_thread.stop()
        while not resolve_queue.emtpy():
            resolve_queue.get()
        ans = {"status": "Stopped"}

    return json.dumps(ans)

@app.route("/status")
def status():

    # global pynq_thread

    res_mes = ""

    if resolve_queue.empty():
        res_mes = "Ready"
    else:
        res_mes = "Working"

    res = {"status": res_mes}
    return json.dumps(res)

@app.route("/")
def index():
    return platform.node()

@app.before_request
def before_request():
    global client_baseurl

    _url = request.url
    parse = urlparse(_url)
    client_baseurl = parse.netloc

if __name__ == "__main__":

    # Check if this script runs as "root" user
    # if os.getuid() != 0:
    #    raise Exception("Must run as root")
    #    sys.exit(1)

    parser = argparse.ArgumentParser(description="PYNQ client (for resolver).")
    parser.add_argument("-p", "--port", action="store", type=int, default=5000, help="Port")
    parser.add_argument("-H", "--host", action="store", type=str, default="192.168.5.1:5000", help="Host address")
    parser.add_argument("--debug", action="store_true", default=False, help="Debug mode.")
    parser.add_argument("-v", "--verbose", action="store_true", default=False, help="Verbose.")
    args = vars(parser.parse_args())

    # Start resolver thread
    resolve_queue = queue.Queue()
    th = threading.Thread(target=resolve, args=())
    th.setDaemon(True)
    th.start()

    if args["debug"]:
        app.debug = True
    app.run(host='0.0.0.0', port=args["port"], threaded=True)

